/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.conndata;

import com.ibm.hwmca.base.rsf.BaseRsfErrorIds;
import com.ibm.hwmca.base.rsf.conndata.RetainConnectionDataManager;
import com.ibm.hwmca.base.rsf.util.RsfFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.Translator;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;

public class ShadowedFile
implements BaseRsfErrorIds,
Serializable,
Persistable {
    private int lrecl;
    private String retainFileName;
    private String fileGeneration;
    private static final int FILE_GENERATION_RECORD = 2;
    private static final int FILE_GENERATION_INDEX = 2;
    private static final int FILE_GENERATION_LENGTH = 8;
    private String stagingFilePath;
    private String dataFilePath;
    private Object fileUpdateGate = new Object();
    private static final String TRACE_MASKT = "XCDISF T";
    private static final String TRACE_MASKF = "XCDISF F";
    private static final String TRACE_MASKD = "XCDISF D";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(-44, "ShadowedFile");

    public ShadowedFile(String dataFile, String stagingFile, String retainFileName, int lrecl) {
        Trace.trace(TRACE_MASKT, "-> ShadowedFile() - " + dataFile + ", " + stagingFile + ", " + retainFileName + ", " + lrecl);
        try {
            this.dataFilePath = RsfFileControl.getFilePath(dataFile) + dataFile;
            Trace.trace(TRACE_MASKF, "   ShadowedFile() - Data file: " + this.dataFilePath);
        }
        catch (HException he) {
            Trace.trace(TRACE_MASKF, "   ShadowedFile() - Error determining path for " + dataFile);
        }
        try {
            this.stagingFilePath = RsfFileControl.getFilePath(stagingFile) + stagingFile;
            Trace.trace(TRACE_MASKF, "   ShadowedFile() - Staging file = " + this.stagingFilePath);
        }
        catch (HException he) {
            Trace.trace(TRACE_MASKF, "   ShadowedFile() - Error determining path for " + stagingFile);
        }
        this.retainFileName = retainFileName;
        this.lrecl = lrecl;
        this.fileGeneration = "";
        Trace.trace(TRACE_MASKT, "<- ShadowedFile()");
    }

    public ShadowedFile(PersistentData data) {
        Persistent persData = (Persistent)data;
        this.retainFileName = persData.retainFileName;
        this.lrecl = persData.lrecl;
        this.stagingFilePath = persData.stagingFilePath;
        this.dataFilePath = persData.dataFilePath;
        this.fileGeneration = persData.fileGeneration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getData() throws HException {
        Trace.trace(TRACE_MASKT, "-> ShadowedFile.getData() - " + this.dataFilePath);
        ArrayList<String> data = new ArrayList<String>();
        Object object = this.fileUpdateGate;
        synchronized (object) {
            BufferedReader from = null;
            try {
                from = new BufferedReader(new FileReader(this.dataFilePath));
            }
            catch (FileNotFoundException fnfe) {
                HException hexc = new HException(fnfe);
                new FrameworkLog(_logInfo, 49, hexc).log();
                throw hexc;
            }
            catch (Throwable e) {
                HException hexc = new HException(e);
                new FrameworkLog(_logInfo, 50, e).log();
                throw hexc;
            }
            String line = null;
            int record = 0;
            try {
                while ((line = from.readLine()) != null) {
                    if (++record == 2) {
                        this.fileGeneration = line.substring(2, 10);
                        Trace.trace(TRACE_MASKF, "   ShadowedFile.getData() - fileGeneration = " + this.fileGeneration);
                    }
                    if (line.substring(0, 1).equals("*")) continue;
                    data.add(line);
                }
            }
            catch (IOException ioe) {
                Trace.trace(TRACE_MASKD, "   ShadowedFile.getData() - Error loading file " + from + ":\n" + ioe.getMessage());
                if (from != null) {
                    try {
                        from.close();
                    }
                    catch (IOException eClose) {
                        // empty catch block
                    }
                }
                HException hexc = new HException(ioe + ", record " + record);
                new FrameworkLog(_logInfo, 51, hexc).log();
                throw hexc;
            }
            if (from != null) {
                try {
                    from.close();
                }
                catch (IOException eClose) {
                    // empty catch block
                }
            }
        }
        String[] outData = data.toArray(new String[0]);
        Trace.trace(TRACE_MASKT, "<- ShadowedFile.getData()");
        return outData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void promote() throws HException {
        block26: {
            Trace.trace(TRACE_MASKT, "-> ShadowedFile.promote() file = " + this.retainFileName);
            Object object = this.fileUpdateGate;
            synchronized (object) {
                IOException ioe42;
                int record;
                String toName;
                BufferedWriter to;
                String fromName;
                BufferedInputStream from;
                block25: {
                    from = null;
                    fromName = this.stagingFilePath;
                    try {
                        from = new BufferedInputStream(new FileInputStream(fromName));
                    }
                    catch (FileNotFoundException fnfe) {
                        HException hexc = new HException(fnfe);
                        new FrameworkLog(_logInfo, 54, hexc).log();
                        throw hexc;
                    }
                    catch (Throwable e) {
                        HException hexc = new HException(e);
                        new FrameworkLog(_logInfo, 55, e).log();
                        throw hexc;
                    }
                    to = null;
                    toName = this.dataFilePath;
                    try {
                        to = new BufferedWriter(new FileWriter(toName));
                    }
                    catch (IOException ioe2) {
                        HException hexc = new HException(ioe2);
                        new FrameworkLog(_logInfo, 52, ioe2).log();
                        throw hexc;
                    }
                    int bytesRead = 0;
                    byte[] buffer = new byte[this.lrecl];
                    record = 0;
                    String line = "";
                    do {
                        if ((bytesRead = from.read(buffer)) != this.lrecl) continue;
                        line = Translator.fromEbcdic(buffer);
                        if (++record == 2) {
                            this.fileGeneration = line.substring(2, 10);
                            Trace.trace(TRACE_MASKF, "   ShadowedFile.promote() - fileGeneration = " + this.fileGeneration);
                        }
                        try {
                            to.write(line);
                            to.newLine();
                        }
                        catch (IOException ioe3) {
                            Trace.trace(TRACE_MASKD, "   ShadowedFile.promote() - Error writing file " + fromName + " to " + toName + "  record = " + record + ":\n" + ioe3.getMessage());
                            HException hexc = new HException(ioe3);
                            new FrameworkLog(_logInfo, 53, ioe3).log();
                            throw hexc;
                        }
                    } while (bytesRead != -1);
                    Object var13_20 = null;
                    if (from == null) break block25;
                    try {
                        from.close();
                    }
                    catch (IOException ioe42) {
                        // empty catch block
                    }
                }
                if (to != null) {
                    try {
                        to.close();
                    }
                    catch (IOException ioe42) {}
                }
                break block26;
                {
                    catch (IOException ioe5) {
                        Trace.trace(TRACE_MASKD, "   ShadowedFile.promote() - Error copying file " + fromName + " to " + toName + "  record = " + record + ":\n" + ioe5.getMessage());
                        HException hexc = new HException(ioe5);
                        new FrameworkLog(_logInfo, 56, ioe5).log();
                        throw hexc;
                    }
                }
                catch (Throwable throwable) {
                    IOException ioe42;
                    Object var13_21 = null;
                    if (from != null) {
                        try {
                            from.close();
                        }
                        catch (IOException ioe42) {
                            // empty catch block
                        }
                    }
                    if (to != null) {
                        try {
                            to.close();
                        }
                        catch (IOException ioe42) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- ShadowedFile.promote()");
    }

    public String getFileGeneration() {
        if (this.fileGeneration.equals("")) {
            try {
                String[] data = this.getData();
            }
            catch (HException hException) {
                // empty catch block
            }
        }
        return this.fileGeneration;
    }

    public String getRetainFileName() {
        return this.retainFileName;
    }

    public String getStagingFilePath() {
        return this.stagingFilePath;
    }

    public void refreshed() {
        try {
            this.promote();
        }
        catch (HException hException) {
            // empty catch block
        }
        RetainConnectionDataManager.fileChanged(this);
    }

    public PersistentData getPersistentData() {
        Persistent persData = new Persistent();
        persData.retainFileName = this.retainFileName;
        persData.lrecl = this.lrecl;
        persData.stagingFilePath = this.stagingFilePath;
        persData.dataFilePath = this.dataFilePath;
        persData.fileGeneration = this.fileGeneration;
        return persData;
    }

    public boolean isUpgradeData() {
        return false;
    }

    class Persistent
    implements PersistentData {
        private static final long serialVersionUID = -961132713278896780L;
        int version = 1;
        String retainFileName;
        int lrecl;
        String stagingFilePath;
        String dataFilePath;
        String fileGeneration;

        Persistent() {
        }
    }
}

